function [ F ] = Q_Fsample( Ntri, Nodes, f )
%Output nodal values of @(x,y) f(x,y) for use in QSpline_Eval 
%   Tri is the numtri x 6 array which indexes triangles like the node index
%   list.  Nodes actually gives their locations in x-y coordinates.  Both
%   may be obtained from Lists.

numtri = size(Ntri,1);
F = zeros(numtri,6,3); 

%F(i,:,1:2) is ith triangle and its 6 nodals with 1 the x and 2 the y

%Evaluate Nodes(:,1) and Nodes(:,2) @ Ntri's values
for i=1:numtri
    for j=1:6
        F(i,j,1) = Nodes(Ntri(i,j),1);
    end
end

for i=1:numtri
    for j=1:6
        F(i,j,2) = Nodes(Ntri(i,j),2);
    end
end

F(:,:,3) = arrayfun(f, F(:,:,1), F(:,:,2));


end

